/*
 * LCNPHY module header file
 *
 * Copyright (C) 2015, Broadcom Corporation
 * All Rights Reserved.
 * 
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 *
 * $Id$
 */

#ifndef _wlc_phy_lcn20_h_
#define _wlc_phy_lcn20_h_

#include <typedefs.h>
#include <wlc_phy_int.h>
/* ********************************************************* */
#include "phy_api.h"
#include "phy_lcn20_ana.h"
#include "phy_lcn20_radio.h"
#include "phy_lcn20_tbl.h"
#include "phy_lcn20_tpc.h"
#include "phy_lcn20_antdiv.h"
#include "phy_lcn20_noise.h"
#include "phy_lcn20_rssi.h"
/* ********************************************************* */

#define LCN20_PAPD_ENABLE
#define PAPD_DEBUG
#define WL_RATESET_SZ	(WL_RATESET_SZ_DSSS + WL_RATESET_SZ_OFDM + WL_RATESET_SZ_HT_MCS)

typedef enum {
	LCN20PHY_TSSI_PRE_PA = 0,
	LCN20PHY_TSSI_POST_PA = 1,
	LCN20PHY_TSSI_EXT = 2,
	LCN20PHY_TSSI_EXT_POST_PAD = 3
} lcn20phy_tssi_mode_t;

typedef enum {
	LCN20PHY_PAPD_OFFSET_SRC_DEFAULT = 0,
	LCN20PHY_PAPD_OFFSET_SRC_NVRAM = 1,
	LCN20PHY_PAPD_OFFSET_SRC_IOVAR = 2
} lcn20phy_papad_offset_init_t;

typedef struct _lcn20phy_txiqcal_ladder_struct {
	uint8 percent;
	uint8 g_env;
} lcn20phy_txiqcal_ladder_t;

typedef struct _lcn20phy_rx_fam_struct {
	int8 freq;
	int32 angle;
	int32 mag;
} lcn20phy_rx_fam_t;

typedef struct _lcn20phy_rxiqcal_phyregs_struct {
	bool   is_orig;
	uint16 RFOverride0;
	uint16 RFOverrideVal0;
	uint16 rfoverride2;
	uint16 rfoverride2val;
	uint16 rfoverride3;
	uint16 rfoverride3_val;
	uint16 rfoverride4;
	uint16 rfoverride4val;
	uint16 rfoverride5;
	uint16 rfoverride5val;
	uint16 rfoverride7;
	uint16 rfoverride7val;
	uint16 rfoverride8;
	uint16 rfoverride8val;
	uint8 bbmult;
	uint8 txidx;
	uint16 SAVE_txpwrctrl_on;
	uint16 PapdEnable0;
	uint16 papr_ctrl;
	uint16 RxSdFeConfig1;
	uint16 RxSdFeConfig6;
	uint16 phyreg2dvga2;
	uint16 SAVE_Core1TxControl;
	uint16 sslpnCalibClkEnCtrl;
	uint16 DSSF_control_0;
	uint16 RxFeCtrl1;
	int16 ofdm_filt_type;
} lcn20phy_rxiqcal_phyregs_t;

typedef struct _lcn20phy_txiqlocal_phyregs_struct {
	bool   is_orig;
	uint8  bbmult;
	uint16 RxFeCtrl1;
	uint16 TxPwrCtrlCmd;
	uint16 RxSdFeConfig1;
	uint16 sslpnCalibClkEnCtrl;
	uint16 AfeCtrlOvr1Val;
	uint16 AfeCtrlOvr1;
	uint16 ClkEnCtrl;
	uint16 lpfbwlutreg3;
	uint16 RFOverride0;
	uint16 RFOverrideVal0;
	uint16 rfoverride4;
	uint16 rfoverride4val;
	uint16 TxPwrCtrlRfCtrlOvr0;
	uint16 PapdEnable;
} lcn20phy_txiqlocal_phyregs_t;

typedef struct _lcn20phy_txiqcal_radioregs_struct {
	bool   is_orig;
	uint16 iqcal_cfg1;
	uint16 tssi_iqcal_ovr1;
	uint16 auxpga_cfg1;
	uint16 iqcal_cfg3;
	uint16 adc_cfg10;
	uint16 AUX_RXPGA_ovr1;
	uint16 GPABuf_ovr1;
	uint16 pa2g_cfg1;
	uint16 rx_adc_ovr1;
	uint16 rx_top_2g_ovr1;
	uint16 tx_top_2g_ovr2;
	uint16 rx_bb_ovr1;
	uint16 rx_bb_ovr2;
	uint16 minipmu_ovr1;
} lcn20phy_txiqcal_radioregs_t;

typedef struct _lcn20phy_rxcal_rxgain_struct {
	int8 lna;
	uint8 tia;
	uint8 far;
	uint8 dvga;
} lcn20phy_rxcal_rxgain_t;

typedef struct _lcn20phy_iq_mismatch_struct {
	int32 angle;
	int32 mag;
	int32 sin_angle;
} lcn20phy_iq_mismatch_t;

#define LCN20PHY_CALBUFFER_MAX_SZ 1024

typedef struct _chan_info_20692_lcn20phy {
	uint8  chan;            /* channel number */
	uint16 freq;            /* in Mhz */
	uint16 pll_vcocal18;
	uint16 pll_vcocal3;
	uint16 pll_vcocal4;
	uint16 pll_vcocal7;
	uint16 pll_vcocal8;
	uint16 pll_vcocal20;
	uint16 pll_vcocal1;
	uint16 pll_vcocal12;
	uint16 pll_vcocal13;
	uint16 pll_vcocal10;
	uint16 pll_vcocal11;
	uint16 pll_vcocal19;
	uint16 pll_vcocal6;
	uint16 pll_vcocal9;
	uint16 pll_vcocal17;
	uint16 pll_vcocal5;
	uint16 pll_vcocal15;
	uint16 pll_vcocal2;
	uint16 pll_mmd1;
	uint16 pll_mmd2;
	uint16 pll_vco2;
	uint16 pll_vco1;
	uint16 pll_lf4;
	uint16 pll_lf5;
	uint16 pll_lf2;
	uint16 pll_lf3;
	uint16 pll_cp1;
	uint16 pll_cp2;
	uint16 logen_cfg2;
	uint16 lna2g_tune;
	uint16 txmix2g_cfg5;
} chan_info_20692_lcn20phy_t;

/* papd structs, keep registers which are not part of iq cal */
typedef struct _lcn20phy_papd_radioregs_struct {
	bool   is_orig;
	uint16 wl_pa2g_cfg1;
	uint16 wl_pa2g_cfg3;
	uint16 wl_pa2g_idac1;
	uint16 wl_pa2g_incap;
	uint16 wl_rxmix2g_cfg1;
	uint16 wl_tx_top_2g_ovr2;
	uint16 wl_tx_dac_cfg5;
	uint16 wl_tia_cfg5;
	uint16 wl_adc_cfg10;
	uint16 wl_tia_cfg8;
	uint16 wl_trsw2g_cfg1;
	uint16 wl_lna2g_cfg1;
	uint16 wl_tx_logen2g_cfg1;
	uint16 wl_tx2g_cfg1;
	uint16 wl_rxrf2g_cfg1;
	uint16 wl_tia_cfg3;
	uint16 wl_pmu_op;
	uint16 wl_adc_cfg8;
	uint16 wl_adc_cfg1;
	phy_txgains_t gains;
	uint16 pa_gain;
	uint16 bbmult;
} lcn20phy_papd_radioregs_t;

typedef struct _lcn20phy_papd_phyregs_struct {
	bool   is_orig;
	uint16 AfeCtrlOvr1Val;
	uint16 AfeCtrlOvr1;
	uint16 RxFeCtrl1;
} lcn20phy_papd_phyregs_struct_t;

typedef struct _lcn20phy_rxiqcal_radioregs_struct {
	bool   is_orig;
	uint16 wl_rx_adc_ovr1;
	uint16 wl_tx_top_2g_ovr1;
	uint16 wl_tx_top_2g_ovr2;
	uint16 wl_rx_top_2g_ovr1;
	uint16 wl_rx_bb_ovr1;
	uint16 wl_minipmu_ovr1;
} lcn20phy_rxiqcal_radioregs_t;

typedef struct _lcn20phy_tempsense_vbat_radioregs_struct {
	bool	is_orig;
	uint16 wl_temp_sens_ovr1;
	uint16 wl_tempsense_cfg;
	uint16 wl_GPABuf_ovr1;
	uint16 wl_testbuf_cfg1;
	uint16 wl_AUX_RXPGA_ovr1;
	uint16 wl_auxpga_cfg1;
	uint16 wl_auxpga_vmid;
	uint16 wl_rx_adc_ovr1;
	uint16 wl_adc_cfg10;
	uint16 wl_tx_dac_cfg5;
	uint16 wl_rx_bb_ovr1;
	uint16 wl_tia_cfg7;
	uint16 wl_tia_cfg8;
	uint16 wl_minipmu_ovr1;
	uint16 wl_vbat_monitor_ovr1;
	uint16 wl_tia_cfg5;
	uint16 wl_tia_cfg6;
	uint16 wl_tia_cfg1;
	uint16 wl_pmu_op;
	uint16 wl_vbat_cfg;
} lcn20phy_tempsense_vbat_radioregs_t;

typedef struct _adc_tuning_array_20962_struct {
	uint16 gi;
	uint16 g21;
	uint16 g32;
	uint16 g43;
	uint16 r12;
	uint16 r34;
	uint16 gff1;
	uint16 gff2;
	uint16 gff3;
	uint16 gff4;
	uint16 g11;
} adc_tuning_array_20962_t;

struct phy_info_lcn20phy {
/* ********************************************************* */
	phy_info_t *pi;
	phy_lcn20_ana_info_t *anai;
	phy_lcn20_radio_info_t *radioi;
	phy_lcn20_tbl_info_t *tbli;
	phy_lcn20_tpc_info_t *tpci;
	phy_lcn20_antdiv_info_t *antdivi;
	phy_lcn20_noise_info_t *noisei;
	phy_lcn20_rssi_info_t *rssii;
/* ********************************************************* */
	bool	calbuffer_inuse;
	uint8	*calbuffer;
	uint16	tssi_idx;	/* Estimated index for target power */
	uint16	cck_tssi_idx;
	uint16	init_ccktxpwrindex;
	uint8	init_txpwrindex;
	uint16	tssi_npt;	/* NPT for TSSI averaging */
	uint16	tssi_tx_cnt; /* Tx frames at that level for NPT calculations */
	uint8	tssi_floor;
	int32	tssi_maxpwr_limit;
	int32	tssi_minpwr_limit;
	int8	tx_power_idx_override; /* Forced tx power index */
	uint8	current_index;
	uint8	txpwr_clamp_dis;
	uint8	txpwr_tssifloor_clamp_dis;
	uint8	txpwr_tssioffset_clamp_dis;
	int32	target_pwr_cck_max;
	int32	target_pwr_ofdm_max;
	int8	offset_targetpwr;
	int16	tempsenseCorr;
	int16	idletssi_corr;
	uint32	*rate_table;
	uint16 idletssi0_cache;
	uint8	auxpga_gain;
	uint8	auxpga_vmid;
	uint8	iqcal_auxpga_gain;
	uint8	iqcal_auxpga_vmid;
	/* LDPC related parameter used to change the ldpc_support register bit */
	bool lcn20_rxldpc_override;
	/* flags */
	bool    ePA;
	uint32	tssical_time;
	bool	uses_rate_offset_table;
	bool	btc_clamp;
	lcn20phy_rxiqcal_phyregs_t *rxiqcal_phyregs;
	lcn20phy_rxiqcal_radioregs_t *rxiqcal_radioregs;
/* #ifdef LCN20_PAPD_ENABLE */
	lcn20phy_papd_radioregs_t *papd_radioregs;
	lcn20phy_papd_phyregs_struct_t *papd_phyregs;
	int16	epsdelta2g;
	bool	papd_enable;
	bool	papd_mcs_comp;
	uint8	papd_end_idx;
	int		papd_valid_retest_num;
	int		papd_cal_idx;
	bool	papd_cal_res_valid;
	lcn20phy_papad_offset_init_t epsdelta2g_flag;
/* #endif LCN20_PAPD_ENABLE */
	int 	base_pwr_dbm;
	int 	target_pwr_dbm;
	bool	do_papd_calidx_est;
	uint8 dccalen_lpbkpath;
	uint8 rxiqcal_lpbkpath;
	int16 cckdigiftype;
	int16 ofdmdigiftype;
	int16 ofdmdigiftypebe;
	int8 cckscale_fctr_db;
	lcn20phy_txiqlocal_phyregs_t *txiqlocal_phyregs;
	lcn20phy_txiqcal_radioregs_t *txiqcal_radioregs;
	/* result of radio rccal */
	uint16 rccal_gmult;
	uint16 rccal_gmult_rc;
	uint8 rccal_dacbuf;
	uint16 rccal_adc_gmult;
	uint32 min_txpwrindex_2g;
	lcn20phy_tx_gain_tbl_entry *txgaintable;
	/* Coefficients for Temperature Conversion to Centigrade */
	/* Temp in deg = (temp_add - (T2-T1)*temp_mult)>>temp_q;  */
	int32 temp_mult;
	int32 temp_add;
	int32 temp_q;
	/* Coefficients for Vbat Conversion to Volts */
	/* Voltage = (vbat_add - (vbat_reading)*vbat_mult)>>vbat_q;  */
	int32 vbat_mult;
	int32 vbat_add;
	int32 vbat_q;
	lcn20phy_tempsense_vbat_radioregs_t *tempsense_vbat_radioregs;
	/* ED thresholds */
	int16 edonthreshold20L;
	int16 edoffthreshold;
	int8 txpwroffset2g[14];
	/* Spur/DSSF modes/params */
	uint8 spurmode; /* from nvram */
	bool  spurmode_override; /* indicate iovar-override */
	uint8 forced_spurmode; /* iovar setting */
	uint8 dssfmode; /* from nvram */
	int16 dssf_thresh[3];
	int8  rssicorr_aci;
	chan_info_20692_lcn20phy_t *tuningtbl;
	/* Tx Gain tables */
	lcn20phy_tx_gain_tbl_entry *gain_table_tx_2g;
	uint8  qam256en;
	/* switch control */
	uint32 swctrlmap_2g[5];
	bool trsw_ctrl_etr;
	int16 ofdm_filt_type;
	/* eLNA bypass */
	uint8 elna_off_gain_idx_2g;
	uint8 tr_isolation;
	uint8 swctrl_gpios; /* enable rfswctrl in GCI gpio control */
	/* Rx gain tables */
	uint8 *gainvaltbl;
	uint32 *gaintbl;
	uint32 *gainidxtbl;
};

extern void wlc_lcn20phy_rx_power(phy_info_t *pi, uint16 num_samps,
	uint8 wait_time, uint8 wait_for_crs, phy_iq_est_t* est, int16 *tot_gain);
extern int wlc_lcn20phy_idle_tssi_reg_iovar(phy_info_t *pi, int32 int_val, bool set, int *err);
extern int wlc_lcn20phy_avg_tssi_reg_iovar(phy_info_t *pi);
extern int32 wlc_lcn20phy_iovar_txpwrctrl(phy_info_t *pi, int32 int_val, int32 *ret_int_ptr);
extern int32 wlc_lcn20phy_iovar_isenabled_tpc(phy_info_t *pi, int32 *is_enabled);
extern void wlc_lcn20phy_get_tssi(phy_info_t *pi, int8 *ofdm_pwr, int8 *cck_pwr);
extern void wlc_phy_txpower_sromlimit_get_lcn20phy(phy_info_t *pi, uint channel,
	ppr_t *max_pwr, uint8 core);
extern int wlc_phy_sample_collect_lcn20phy(phy_info_t *pi, wl_samplecollect_args_t *collect,
	uint32 *buf);
extern int wlc_lcn20phy_aci_modes(phy_info_t *pi, int wanted_mode);
extern void wlc_lcn20phy_aci_init(phy_info_t *pi);
extern bool wlc_lcn20phy_acimode_valid(phy_info_t *pi, int wanted_mode);

extern void
wlc_phy_set_papd_offset_lcn20phy(phy_info_t *pi, int16 int_val);
extern int
wlc_phy_get_papd_offset_lcn20phy(phy_info_t *pi);

#if defined(BCMDBG) || defined(WLTEST) || defined(MACOSX) || defined(ATE_BUILD)
extern int16
wlc_lcn20phy_tempsense(phy_info_t *pi, bool mode);
#endif /* defined(BCMDBG) || defined(WLTEST) || defined(MACOSX) || defined(ATE_BUILD) */

#if defined(WLTEST)
extern void wlc_lcn20phy_force_spurmode(phy_info_t *pi, int16 int_val);
#endif /* WLTEST */
void wlc_phy_init_lcn20phy(phy_info_t *pi);
void wlc_lcn20phy_anacore(phy_info_t *pi, bool on);
void wlc_lcn20phy_switch_radio(phy_info_t *pi, bool on);
void wlc_phy_txpower_recalc_target_lcn20phy(phy_info_t *pi);
bool wlc_lcn20phy_txpwr_srom_read(phy_info_t *pi);
void wlc_lcn20phy_read_table(phy_info_t *pi, phytbl_info_t *pti);
void wlc_lcn20phy_write_table(phy_info_t *pi, const phytbl_info_t *pti);
#endif /* _wlc_phy_lcn20_h_ */
